<?php $__env->startSection('send_money_content'); ?>

    <div class="progress-steps-form">
        <form action="<?php echo e(route('user.send-money.now')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-xl-6 col-md-12">
                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('User Email')); ?></label>
                    <div class="input-group">
                        <input type="email" name="email" required class="form-control userCheck"
                               placeholder="User Email">
                    </div>
                    <div class="input-info-text notifyUser"></div>
                </div>
                <div class="col-xl-6 col-md-12">
                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Enter Amount')); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control sendAmount" name="amount" required
                               placeholder="Enter Amount" aria-label="Amount"
                               oninput="this.value = validateDouble(this.value)" aria-describedby="basic-addon1">
                        <span class="input-group-text" id="basic-addon1"><?php echo e($currency); ?></span>
                    </div>
                    <div
                        class="input-info-text"><?php echo e('Minimum '. setting('min_send','fee').' '.$currency.' and Maximum '. setting('max_send','fee').' '.$currency); ?></div>
                </div>
                <div class="col-xl-12 col-md-12 mt-3">
                    <label for="exampleFormControlInput1"
                           class="form-label"><?php echo e(__('Send Money Note (Optional)')); ?></label>
                    <div class="input-group">
                        <textarea class="form-control-textarea" placeholder="Send Money Note" name="note"></textarea>
                    </div>
                </div>
            </div>
            <div class="transaction-list table-responsive">
                <div class="user-panel-title">
                    <h3><?php echo e(__('Send Money Details')); ?></h3>
                </div>
                <table class="table">
                    <tbody>
                    <tr>
                        <td><strong><?php echo e(__('Payment Amount')); ?></strong></td>
                        <td><span class="previewAmount"></span> <?php echo e($currency); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo e(__('Charge')); ?></strong></td>
                        <td><span class="previewCharge"></span> <?php echo e($currency); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo e(__('User Email')); ?></strong></td>
                        <td class="userEmail"></td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="buttons">
                <button type="submit" class="site-btn blue-btn">
                    <?php echo e(__('Send Money')); ?><i class="anticon anticon-double-right"></i>
                </button>
            </div>
        </form>

    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script>
        $('.userCheck').on('change',function (e) {
            "use strict"
            var email = $(this).val();

            $('.userEmail').text(email)

            var url = '<?php echo e(route("user.exist",":email")); ?>';
            url = url.replace(':email', email);
            $.get(url, function (data) {
                $('.notifyUser').text(data)
            })
        })

        $('.sendAmount').on('keyup',function (e) {
            "use strict"
            var amount = $(this).val();
            $('.previewAmount').text(amount);

            var charge = <?php echo json_encode(setting('send_charge', 'fee'), 512) ?>;
            var chargeType = <?php echo json_encode(setting('send_charge_type', 'fee'), 512) ?>;


            if (chargeType === 'percentage') {
                var finalCharge = calPercentage(amount, charge)
            } else {
                var finalCharge = charge

            }
            $('.previewCharge').text(finalCharge);
        })


    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('frontend.send_money.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/novajlkl/invest.novatradeai.online/resources/views/frontend/send_money/now.blade.php ENDPATH**/ ?>