<header class="header">
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="{{route('home')}}"><img src="{{ asset(setting('site_logo','global')) }}"
                                                                  alt=""/></a>
            <button
                class="navbar-toggler"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent"
                aria-expanded="false"
                aria-label="Toggle navigation"
            >
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav m-auto mb-2 mb-lg-0 main-nav">
                    @foreach($navigations as $navigation)
                        @if($navigation->page->status|| $navigation->page_id == null)
                            <li class="nav-item">
                                <a class="nav-link @if(url($navigation->url) == Request::url() ) active @endif"
                                   href="{{ url($navigation->url) }}">{{ $navigation->name }}</a>
                            </li>
                        @endif
                    @endforeach

                </ul>
                <div class="header-right-btn">
                    @auth('web')
                        <a href="{{route('user.dashboard')}}" class="site-btn-sm grad-btn"><i
                                class="anticon anticon-dashboard"></i>{{ __('Dashboard') }}</a>

                    @else
                        <a href="{{route('register')}}" class="site-btn-sm primary-btn"><i
                                class="anticon anticon-user-add"></i>{{ __('Register') }}</a>
                        <a href="{{route('login')}}" class="site-btn-sm grad-btn ms-2"><i
                                class="anticon anticon-user"></i>{{ __('Account') }}</a>

                    @endauth

                    <div class="color-switcher">
                        <i icon-name="moon" class="dark-icon" data-mode="dark"></i>
                        <i icon-name="sun" class="light-icon" data-mode="light"></i>
                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>
@push('script')
    <script>
        // Color Switcher
        $(".color-switcher").on('click', function () {
            "use strict"
            $("body").toggleClass("dark-theme");
            var url = '{{ route("mode-theme") }}';
            $.get(url)
        });
    </script>
    <!-- Social Proof with Purple Background and Sequential Display -->
<style>
.sp-container {
  position: fixed;
  bottom: 20px;
  left: 20px;
  z-index: 9999;
  width: 280px;
  font-family: Arial, sans-serif;
}
.sp-notification {
  background: #8a2be2; /* Purple background */
  border-left: 4px solid #5D5CDE;
  border-radius: 4px;
  box-shadow: 0 2px 10px rgba(0,0,0,0.1);
  padding: 12px;
  margin-bottom: 10px;
  display: flex;
  transform: translateX(-120%);
  opacity: 0;
  transition: all 0.5s ease;
  position: relative;
  color: white;
}
.sp-notification.show {
  transform: translateX(0);
  opacity: 1;
}
.sp-close {
  position: absolute;
  top: 8px;
  right: 8px;
  width: 18px;
  height: 18px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  background: rgba(255,255,255,0.2);
  color: white;
  font-size: 12px;
  cursor: pointer;
  transition: all 0.2s ease;
}
.sp-close:hover {
  background: rgba(255,255,255,0.4);
}
.sp-icon {
  width: 36px;
  height: 36px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-right: 12px;
  color: white;
  font-weight: bold;
}
.sp-deposit { background: #4CAF50; }
.sp-withdraw { background: #FF9800; }
.sp-referral { background: #2196F3; }
.sp-content {
  flex: 1;
  padding-right: 14px;
}
.sp-name {
  font-weight: bold;
  margin-bottom: 3px;
  color: white;
}
.sp-action {
  font-size: 14px;
  color: rgba(255,255,255,0.9);
}
.sp-amount {
  font-weight: bold;
  color: #ffd700; /* Gold for better contrast */
}
.sp-time {
  font-size: 12px;
  color: rgba(255,255,255,0.7);
  margin-top: 3px;
}
@media (prefers-color-scheme: dark) {
  .sp-notification {
    background: #6a1b9a; /* Darker purple for dark mode */
  }
}
</style>

<div id="spContainer" class="sp-container"></div>

<script>
// Create social proof notifications immediately after page load
document.addEventListener('DOMContentLoaded', function() {
  // Create container if it doesn't exist
  var container = document.getElementById('spContainer');
  if (!container) {
    container = document.createElement('div');
    container.id = 'spContainer';
    container.className = 'sp-container';
    document.body.appendChild(container);
  }
  
  // Data for generation
  var firstNames = ["John", "Emily", "Michael", "Sarah", "David", "Jessica", "James", "Jennifer", "Robert", "Linda", "William", "Richard", "Thomas", "Daniel", "Matthew", "Anthony"];
  var lastNames = ["Smith", "Johnson", "Williams", "Brown", "Jones", "Miller", "Davis", "Wilson", "Taylor", "Clark", "Hall", "Lee", "Allen", "Young", "King", "Wright"];
  
  // Define notification types in sequence
  var types = [
    {type: "deposit", icon: "↓", text: "invested", cssClass: "sp-deposit", min: 100, max: 95000},
    {type: "withdraw", icon: "↑", text: "withdrew", cssClass: "sp-withdraw", min: 100, max: 95000},
    {type: "referral", icon: "★", text: "earned from referral", cssClass: "sp-referral", min: 100, max: 1000}
  ];
  var typeIndex = 0; // Track which notification type to show next
  
  // Function to handle close button click
  function setupCloseButton(notification) {
    var closeBtn = notification.querySelector('.sp-close');
    if (closeBtn) {
      closeBtn.addEventListener('click', function(e) {
        e.stopPropagation();
        notification.classList.remove('show');
        setTimeout(function() {
          notification.remove();
        }, 500);
      });
    }
  }
  
  // Create a notification
  function createNotification() {
    // Get random name
    var firstName = firstNames[Math.floor(Math.random() * firstNames.length)];
    var lastName = lastNames[Math.floor(Math.random() * lastNames.length)];
    var fullName = firstName + " " + lastName;
    
    // Get next notification type in sequence
    var notificationType = types[typeIndex];
    
    // Increment type index and wrap around to 0 when we reach the end
    typeIndex = (typeIndex + 1) % types.length;
    
    // Random amount and time
    var amount = Math.floor(Math.random() * (notificationType.max - notificationType.min + 1)) + notificationType.min;
    var amountFormatted = "$" + amount.toLocaleString();
    var minutes = Math.floor(Math.random() * 30) + 1;
    var timeAgo = minutes + " minute" + (minutes > 1 ? "s" : "") + " ago";
    
    // Create notification element
    var notification = document.createElement('div');
    notification.className = 'sp-notification';
    notification.style.background = '#8a2be2'; // Ensure purple background
    
    notification.innerHTML = 
      '<div class="sp-close">✕</div>' +
      '<div class="sp-icon ' + notificationType.cssClass + '">' + notificationType.icon + '</div>' +
      '<div class="sp-content">' +
        '<div class="sp-name">' + fullName + '</div>' +
        '<div class="sp-action">' + notificationType.text + ' <span class="sp-amount">' + amountFormatted + '</span></div>' +
        '<div class="sp-time">' + timeAgo + '</div>' +
      '</div>';
    
    // Add to container
    container.appendChild(notification);
    
    // Set up close button event
    setupCloseButton(notification);
    
    // Trigger animation
    setTimeout(function() {
      notification.classList.add('show');
    }, 100);
    
    // Auto-remove after display time (if not manually closed)
    setTimeout(function() {
      if (document.body.contains(notification)) {
        notification.classList.remove('show');
        setTimeout(function() {
          if (document.body.contains(notification)) {
            notification.remove();
          }
        }, 500);
      }
    }, 5000);
  }
  
  // Start notifications
  setTimeout(function() {
    createNotification();
    setInterval(createNotification, 8000);
  }, 2000);
});
</script>
<!-- WhatsApp Floating Icon -->
<style>
.whatsapp-float {
  position: fixed;
  width: 60px;
  height: 60px;
  bottom: 20px;
  right: 20px;
  background-color: #25d366;
  border-radius: 50%;
  box-shadow: 2px 2px 10px rgba(0,0,0,0.3);
  z-index: 1000;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}
.whatsapp-float:hover {
  transform: scale(1.1);
  background-color: #20b858;
}
.whatsapp-float img {
  width: 35px;
  height: 35px;
}
</style>

<!-- WhatsApp Floating Button -->
<a href="https://wa.me/qr/WIESRPN4O6UHM1" 
   class="whatsapp-float" 
   target="_blank" 
   title="Chat with us on WhatsApp">
  <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp">
</a>
@endpush
